/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Component;

public class CurrentlyAttackingComponent
extends Component {
    private float totalAttackDuration;
    private float currentAttackDuration;
    private boolean defaultStartingAttack;

    public CurrentlyAttackingComponent(float attackDuration, boolean startingAttack) {
        this.setTotalAttackDuration(attackDuration);
        this.defaultStartingAttack = false;
        if (startingAttack) {
            this.defaultStartingAttack = true;
            attackDuration = 0.0f;
        }
        this.setCurrentAttackDuration(attackDuration);
    }

    public void startAttack() {
        this.setCurrentAttackDuration(0.0f);
    }

    public boolean checkAttacking() {
        return this.currentAttackDuration < this.totalAttackDuration;
    }

    @Override
    public String getComponentName() {
        return "CurrentlyAttackingComponent";
    }

    @Override
    public void add(Component toAdd) {
        if (this.sameType(toAdd)) {
            this.startAttack();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "-{" + this.getCurrentAttackDuration() + "/" + this.getTotalAttackDuration() + "}";
    }

    public float getTotalAttackDuration() {
        return this.totalAttackDuration;
    }

    public void setTotalAttackDuration(float totalAttackDuration) {
        this.totalAttackDuration = totalAttackDuration;
    }

    public float getCurrentAttackDuration() {
        return this.currentAttackDuration;
    }

    public void setCurrentAttackDuration(float currentAttackDuration) {
        this.currentAttackDuration = currentAttackDuration;
    }

    @Override
    public Component copy() {
        return new CurrentlyAttackingComponent(this.getTotalAttackDuration(), this.defaultStartingAttack);
    }
}

