/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Entity;
import com.adsittech.dinotamer.EntityController;
import com.adsittech.dinotamer.Game;
import com.adsittech.dinotamer.HealthComponent;
import com.adsittech.dinotamer.PositionComponent;
import com.adsittech.dinotamer.SpriteComponent;
import com.adsittech.dinotamer.TeamComponent;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import java.util.ArrayList;

public class GameActor
extends Actor {
    private Game game;
    private ShapeRenderer shapeRenderer;

    public GameActor(Game game, ShapeRenderer shapeRenderer) {
        this.game = game;
        this.shapeRenderer = shapeRenderer;
    }

    public ArrayList<Entity> gameEntitiesReordered() {
        ArrayList<Entity> initialList = new ArrayList<Entity>(this.game.getEntityController().getEntities());
        ArrayList<Entity> toReturn = new ArrayList<Entity>();
        while (initialList.size() > 0) {
            Entity entity = initialList.get(initialList.size() - 1);
            toReturn.add(entity);
            initialList.remove(entity);
        }
        return toReturn;
    }

    public void draw(SpriteBatch batch, float parentAlpha) {
        ArrayList<Rectangle> redHealthRectangles = new ArrayList<Rectangle>();
        ArrayList<Rectangle> greenHealthRectangles = new ArrayList<Rectangle>();
        ArrayList<Rectangle> blueHealthRectangles = new ArrayList<Rectangle>();
        for (Entity entity : this.gameEntitiesReordered()) {
            TextureAtlas.AtlasRegion texture;
            SpriteComponent sprite;
            Rectangle defenseArea;
            PositionComponent positionComponent = (PositionComponent)entity.getComponent("PositionComponent");
            if (positionComponent == null || (defenseArea = EntityController.getActualDefenseAreaRectangle(entity)) == null || (sprite = (SpriteComponent)entity.getComponent("SpriteComponent")) == null || (texture = sprite.retrieveCurrentTexture()) == null) continue;
            float rotation = 0.0f;
            if (texture.rotate) {
                rotation = 270.0f;
            }
            Rectangle boundingRectangle = new Rectangle(sprite.getTextureRectangle(texture));
            boundingRectangle.x = positionComponent.getPosition().x;
            boundingRectangle.y = positionComponent.getPosition().y;
            batch.draw((TextureRegion)texture, boundingRectangle.x - boundingRectangle.width / 2.0f, boundingRectangle.y - boundingRectangle.height / 2.0f, boundingRectangle.width / 2.0f, boundingRectangle.height / 2.0f, boundingRectangle.width, boundingRectangle.height, 1.0f, 1.0f, rotation);
            HealthComponent health = (HealthComponent)entity.getComponent("HealthComponent");
            if (health == null) continue;
            redHealthRectangles.add(new Rectangle(boundingRectangle.x - boundingRectangle.width / 2.0f, boundingRectangle.y - boundingRectangle.height / 2.0f - 25.0f, boundingRectangle.width, 20.0f));
            float healthSlotWidth = boundingRectangle.width / (float)health.getTotalHealth();
            Rectangle toAdd = new Rectangle(boundingRectangle.x - boundingRectangle.width / 2.0f, boundingRectangle.y - boundingRectangle.height / 2.0f - 25.0f, (float)health.getHealth() * healthSlotWidth, 20.0f);
            TeamComponent team = (TeamComponent)entity.getComponent("TeamComponent");
            if (team != null && team.getTeam() == 1) {
                greenHealthRectangles.add(toAdd);
                continue;
            }
            blueHealthRectangles.add(toAdd);
        }
        batch.end();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(Color.RED);
        for (Rectangle toDraw : redHealthRectangles) {
            this.shapeRenderer.rect(toDraw.x, toDraw.y, toDraw.width, toDraw.height);
        }
        this.shapeRenderer.setColor(Color.BLUE);
        for (Rectangle toDraw : blueHealthRectangles) {
            this.shapeRenderer.rect(toDraw.x, toDraw.y, toDraw.width, toDraw.height);
        }
        this.shapeRenderer.setColor(Color.GREEN);
        for (Rectangle toDraw : greenHealthRectangles) {
            this.shapeRenderer.rect(toDraw.x, toDraw.y, toDraw.width, toDraw.height);
        }
        this.shapeRenderer.end();
        batch.begin();
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }
}

