/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Component;

public class HealthComponent
extends Component {
    private int totalHealth;
    private int health;

    public HealthComponent(int health) {
        this.setTotalHealth(health);
        this.setHealth(health);
    }

    @Override
    public String getComponentName() {
        return "HealthComponent";
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        if (health < 0) {
            health = 0;
        } else if (health > this.totalHealth) {
            health = this.totalHealth;
        }
        this.health = health;
    }

    public int getTotalHealth() {
        return this.totalHealth;
    }

    public void setTotalHealth(int totalHealth) {
        this.totalHealth = totalHealth;
    }

    @Override
    public void add(Component toAdd) {
        if (this.sameType(toAdd)) {
            this.health += ((HealthComponent)toAdd).getHealth();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "-{" + this.getHealth() + "/" + this.getTotalHealth() + "}";
    }

    @Override
    public Component copy() {
        return new HealthComponent(this.health);
    }
}

