/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Component;

public class HealthRegenComponent
extends Component {
    private int healthRegenAmount;
    private float generationTime;
    private float timeSinceLastGeneration;

    public HealthRegenComponent(int healthRegen, float time) {
        this.setHealthRegenAmount(healthRegen);
        this.setGenerationTime(time);
        this.resetTime();
    }

    @Override
    public String getComponentName() {
        return "HealthRegenComponent";
    }

    public int getHealthRegenAmount() {
        return this.healthRegenAmount;
    }

    public void updateTimer(float delta) {
        this.timeSinceLastGeneration += delta;
    }

    public boolean checkGenerateHealth() {
        return this.timeSinceLastGeneration >= this.generationTime;
    }

    public void resetTime() {
        this.setTimeSinceLastGeneration(0.0f);
    }

    public void setHealthRegenAmount(int healthRegen) {
        this.healthRegenAmount = healthRegen;
    }

    @Override
    public void add(Component toAdd) {
        if (this.sameType(toAdd)) {
            this.healthRegenAmount = ((HealthRegenComponent)toAdd).getHealthRegenAmount();
            this.generationTime = ((HealthRegenComponent)toAdd).getGenerationTime();
            this.timeSinceLastGeneration = ((HealthRegenComponent)toAdd).getTimeSinceLastGeneration();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "-{" + this.getHealthRegenAmount() + ", " + this.getTimeSinceLastGeneration() + "/" + this.getGenerationTime() + "}";
    }

    @Override
    public Component copy() {
        return new HealthRegenComponent(this.healthRegenAmount, this.generationTime);
    }

    public float getGenerationTime() {
        return this.generationTime;
    }

    public void setGenerationTime(float generationTime) {
        this.generationTime = generationTime;
    }

    public float getTimeSinceLastGeneration() {
        return this.timeSinceLastGeneration;
    }

    public void setTimeSinceLastGeneration(float timeSinceLastGeneration) {
        this.timeSinceLastGeneration = timeSinceLastGeneration;
    }
}

