/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Component;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.TimeUtils;
import java.util.Iterator;

public class HitTrackerComponent
extends Component {
    private ObjectMap<Integer, Long> hittingEntityIDToTimeHit = new ObjectMap();

    public long getLastHitTime(int entityID) {
        return (Long)this.hittingEntityIDToTimeHit.get((Object)entityID, (Object)new Long(-1L));
    }

    public int getLastHittingEntityID() {
        int toReturn = -1;
        long maxHitTime = -1L;
        Iterator entityIDS = this.hittingEntityIDToTimeHit.keys().iterator();
        while (entityIDS.hasNext()) {
            int entityID = (Integer)entityIDS.next();
            long hitTime = (Long)this.hittingEntityIDToTimeHit.get((Object)entityID);
            if (hitTime <= maxHitTime) continue;
            toReturn = entityID;
            maxHitTime = hitTime;
        }
        return toReturn;
    }

    @Override
    public String getComponentName() {
        return "HitTrackerComponent";
    }

    public void recordHit(int id) {
        this.hittingEntityIDToTimeHit.put((Object)id, (Object)TimeUtils.millis());
    }

    @Override
    public void add(Component toAdd) {
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "-{[" + this.getHittingEntityIDToTimeHit() + "]}";
    }

    @Override
    public Component copy() {
        return new HitTrackerComponent();
    }

    public ObjectMap<Integer, Long> getHittingEntityIDToTimeHit() {
        return this.hittingEntityIDToTimeHit;
    }

    public void setHittingEntityIDToTimeHit(ObjectMap<Integer, Long> hittingEntityIDToTimeHit) {
        this.hittingEntityIDToTimeHit = hittingEntityIDToTimeHit;
    }
}

