/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.CurrentlyAttackingComponent;
import com.adsittech.dinotamer.Entity;
import com.adsittech.dinotamer.EntityFactory;
import com.adsittech.dinotamer.Game;
import com.adsittech.dinotamer.GameActor;
import com.adsittech.dinotamer.SoundEffectComponent;
import com.adsittech.dinotamer.SpriteComponent;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;

public class MyGdxGame
implements ApplicationListener {
    private OrthographicCamera camera;
    private ShapeRenderer shapeRenderer;
    private TextureAtlas textureAtlas;
    private TextureAtlas.AtlasRegion person_away;
    private TextureAtlas.AtlasRegion person_away_2;
    private TextureAtlas.AtlasRegion person_away_with_weapon;
    private TextureAtlas.AtlasRegion person_away_with_weapon_2;
    private TextureAtlas.AtlasRegion person_away_with_weapon_left;
    private TextureAtlas.AtlasRegion person_away_with_weapon_left_2;
    private TextureAtlas.AtlasRegion person_toward;
    private TextureAtlas.AtlasRegion person_toward_2;
    private TextureAtlas.AtlasRegion person_toward_with_left_weapon;
    private TextureAtlas.AtlasRegion person_toward_with_left_weapon_2;
    private TextureAtlas.AtlasRegion person_toward_with_weapon;
    private TextureAtlas.AtlasRegion person_toward_with_weapon_2;
    private TextureAtlas.AtlasRegion long_neck_1;
    private TextureAtlas.AtlasRegion long_neck_left_1;
    private TextureAtlas.AtlasRegion long_neck_2;
    private TextureAtlas.AtlasRegion long_neck_left_2;
    private TextureAtlas.AtlasRegion long_neck_attacking_1;
    private TextureAtlas.AtlasRegion long_neck_attacking_left_1;
    private TextureAtlas.AtlasRegion salamander_1;
    private TextureAtlas.AtlasRegion salamander_left_1;
    private TextureAtlas.AtlasRegion salamander_2;
    private TextureAtlas.AtlasRegion salamander_left_2;
    private TextureAtlas.AtlasRegion triceritops_1;
    private TextureAtlas.AtlasRegion triceritops_left_1;
    private TextureAtlas.AtlasRegion triceritops_2;
    private TextureAtlas.AtlasRegion triceritops_left_2;
    private TextureAtlas.AtlasRegion triceritops_attacking;
    private TextureAtlas.AtlasRegion triceritops_attacking_left;
    private Texture backgroundTexture;
    private TextureRegion textBoxBackgroundRegion;
    private TextureRegion textBoxCursorRegion;
    private TextureRegion textBoxSelectRegion;
    private TextureRegion buttonDownBackgroundRegion;
    private TextureRegion buttonUpBackgroundRegion;
    private TextureRegion sliderBackgroundRegion;
    private TextureRegion ballRegion;
    private TextureRegion backgroundRegion;
    private SpriteBatch batch;
    private Label.LabelStyle labelStyle;
    private Label.LabelStyle subTitleLabelStyle;
    private Label.LabelStyle titleLabelStyle;
    private TextField.TextFieldStyle textFieldStyle;
    private TextButton.TextButtonStyle textButtonStyle;
    private TextButton.TextButtonStyle checkableTextButtonStyle;
    private ScrollPane.ScrollPaneStyle scrollPaneStyle;
    private Slider.SliderStyle sliderStyle;
    private Table table;
    private Table tableHolder;
    private ScrollPane tableScrollPane;
    private BitmapFont font;
    private BitmapFont largeFont;
    private BitmapFont extraLargeFont;
    private Color fontColor;
    private EntityFactory entityFactory;
    private Stage stage;
    private Game game;
    private Group gameGroup;
    private Label gameScore;
    private Label gameTime;
    private GameActor gameActor;
    private Sound fire;
    private Sound roar;
    private Sound hit;
    public static final int SCREEN_HOME = 0;
    public static final int SCREEN_GAME = 1;
    public static final int SCREEN_MENU = 2;
    public static final int SCREEN_ABOUT = 3;
    public static final int SCREEN_STORY = 4;
    public static final int SCREEN_HELP = 5;
    public static final int SCREEN_GAME_OVER = 6;
    private Music gameMusic;
    private Music menuMusic;
    private Boolean soundIsOn;
    private String musicPath;
    private Preferences preferences;
    private static final String defaultMusicPath = "sound/music/musicB.ogg";
    private static final String musicAPath = "sound/music/musicA.ogg";
    private static final String musicBPath = "sound/music/musicB.ogg";
    private static final String musicCPath = "sound/music/musicC.ogg";
    Array<Integer> screenOrder;

    public void create() {
        this.preferences = Gdx.app.getPreferences("preferences");
        this.screenOrder = new Array();
        this.initializeGraphics();
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 800.0f, 800.0f);
        this.shapeRenderer = new ShapeRenderer();
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.game = new Game(this.entityFactory);
        this.gameGroup = new Group();
        this.gameActor = new GameActor(this.game, this.shapeRenderer);
        this.gameScore = new Label((CharSequence)"Tada!", this.labelStyle);
        this.gameTime = new Label((CharSequence)"Tada!", this.labelStyle);
        this.gameTime.setX(10.0f);
        this.gameTime.setY(100.0f);
        this.gameScore.setX(10.0f);
        this.gameScore.setY(50.0f);
        this.gameGroup.addActor((Actor)this.gameTime);
        this.gameGroup.addActor((Actor)this.gameScore);
        this.batch = new SpriteBatch();
        this.stage.setCamera((Camera)this.camera);
        this.gameGroup.addActor((Actor)this.gameActor);
        this.stage.addActor((Actor)this.gameGroup);
        this.gameActor.setVisible(false);
        this.fire = Gdx.audio.newSound(Gdx.files.internal("sound/effects/fire.wav"));
        this.roar = Gdx.audio.newSound(Gdx.files.internal("sound/effects/roar.wav"));
        this.hit = Gdx.audio.newSound(Gdx.files.internal("sound/effects/hit_1.wav"));
        this.backgroundTexture = new Texture(Gdx.files.internal("images/backgroundtexture.png"));
        this.stage.addCaptureListener((EventListener)new InputListener(){

            public boolean keyDown(InputEvent event, int keycode) {
                MyGdxGame.this.handleKeyDownEvent(keycode);
                return false;
            }

            public boolean keyUp(InputEvent event, int keycode) {
                MyGdxGame.this.handleKeyUpEvent(keycode);
                return false;
            }

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                MyGdxGame.this.handleClick(x, y, button);
                return false;
            }
        });
        this.menuMusic = Gdx.audio.newMusic(Gdx.files.internal("sound/music/musicMenu.ogg"));
        this.menuMusic.setLooping(true);
        this.gameMusic = Gdx.audio.newMusic(Gdx.files.internal(this.getMusicPath()));
        this.gameMusic.setLooping(true);
        Gdx.input.setInputProcessor((InputProcessor)this.stage);
        this.openScreen(0);
    }

    public Integer getCurrentScreen() {
        if (this.screenOrder.size > 0) {
            return (Integer)this.screenOrder.peek();
        }
        return -1;
    }

    public void openHomeScreen() {
        Label label = new Label((CharSequence)"Dino Tamer", this.titleLabelStyle);
        this.table.add((Actor)label);
        this.table.row().padTop(50.0f).padBottom(30.0f);
        TextButton toAdd = new TextButton("Start Game", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.startGameClicked();
            }
        });
        this.table.add((Actor)toAdd);
        this.table.row().padBottom(30.0f);
        toAdd = new TextButton("Story", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(4);
            }
        });
        this.table.add((Actor)toAdd);
        this.table.row().padBottom(30.0f);
        toAdd = new TextButton("Help", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(5);
            }
        });
        this.table.add((Actor)toAdd);
        this.table.row().padBottom(30.0f);
        toAdd = new TextButton("Menu", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(2);
            }
        });
        this.table.add((Actor)toAdd);
        this.table.row().padBottom(30.0f);
        toAdd = new TextButton("About", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(3);
            }
        });
        this.table.add((Actor)toAdd);
    }

    public void swapMusic(String newMusicLocation) {
        FileHandle toLoad = Gdx.files.internal(newMusicLocation);
        if (toLoad.exists()) {
            if (this.menuMusic.isPlaying()) {
                this.menuMusic.stop();
            }
            this.setMusicPath(newMusicLocation);
            this.gameMusic.stop();
            this.gameMusic = Gdx.audio.newMusic(toLoad);
            this.gameMusic.setLooping(true);
            if (this.getSoundIsOn().booleanValue()) {
                this.gameMusic.play();
            }
        }
    }

    public void openMenuScreen() {
        this.table.clear();
        Label lblMenu = new Label((CharSequence)"Menu", this.titleLabelStyle);
        String message = "Turn Sound On";
        if (this.getSoundIsOn().booleanValue()) {
            message = "Turn Sound Off";
        }
        final TextButton btnSwapSound = new TextButton(message, this.textButtonStyle);
        btnSwapSound.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.swapSound();
                String message = "Turn Sound On";
                if (MyGdxGame.this.getSoundIsOn().booleanValue()) {
                    message = "Turn Sound Off";
                }
                btnSwapSound.setText(message);
            }
        });
        Label lblMusic = new Label((CharSequence)"Music", this.subTitleLabelStyle);
        TextButton btnMusicA = new TextButton("A", this.checkableTextButtonStyle);
        btnMusicA.setChecked(this.getMusicPath().equals(musicAPath));
        btnMusicA.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.swapMusic(MyGdxGame.musicAPath);
            }
        });
        TextButton btnMusicB = new TextButton("B", this.checkableTextButtonStyle);
        btnMusicB.setChecked(this.getMusicPath().equals("sound/music/musicB.ogg"));
        btnMusicB.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.swapMusic("sound/music/musicB.ogg");
            }
        });
        TextButton btnMusicC = new TextButton("C", this.checkableTextButtonStyle);
        btnMusicC.setChecked(this.getMusicPath().equals(musicCPath));
        btnMusicC.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.swapMusic(MyGdxGame.musicCPath);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((Button)btnMusicA);
        buttonGroup.add((Button)btnMusicB);
        buttonGroup.add((Button)btnMusicC);
        buttonGroup.setMaxCheckCount(1);
        buttonGroup.setMinCheckCount(1);
        TextButton btnNewGame = new TextButton("New Game", this.textButtonStyle);
        btnNewGame.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.startGameClicked();
            }
        });
        TextButton btnHomeScreen = new TextButton("Home Screen", this.textButtonStyle);
        btnHomeScreen.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(0);
            }
        });
        TextButton btnOK = new TextButton("OK", this.textButtonStyle);
        btnOK.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.returnToPreviousScreen();
            }
        });
        this.table.center();
        this.table.add((Actor)lblMenu);
        this.table.row().padBottom(50.0f).padTop(10.0f);
        this.table.add((Actor)btnSwapSound);
        this.table.row();
        this.table.add((Actor)lblMusic);
        this.table.row().padBottom(50.0f).padTop(10.0f);
        Table innerTable = new Table();
        innerTable.add((Actor)btnMusicA);
        innerTable.add((Actor)btnMusicB).padLeft(20.0f).padRight(20.0f);
        innerTable.add((Actor)btnMusicC);
        this.table.add((Actor)innerTable);
        this.table.row();
        if (this.game.getStatus() == 2) {
            innerTable = new Table().padBottom(10.0f);
            innerTable.add((Actor)btnNewGame);
            innerTable.add((Actor)btnHomeScreen).padLeft(20.0f);
            this.table.add((Actor)innerTable);
            this.table.row();
        }
        this.table.add((Actor)btnOK);
    }

    public void handleKeyDownEvent(int keyCode) {
        this.game.handleKeyDownEvent(keyCode);
    }

    public void handleKeyUpEvent(int keyCode) {
        this.game.handleKeyUpEvent(keyCode);
    }

    public void openStoryScreen() {
        Label label = new Label((CharSequence)"Story", this.titleLabelStyle);
        this.table.add((Actor)label);
        this.table.row().padBottom(50.0f);
        String toShow = "Hello,\n\n Congratulations on your choice to become a DinoTamer! While you are used to having dinosaurs with you in your everyday life, used from transportation to simple household pets, we must always be prepared in case technology fails! As such, before getting to use technology, you must first learn to tame dinosaurs with the basics. In this case you have a stick, which you should always be able to find. If either you or the practice dinosaurs are in need of nursing, there is an instant teleport set up.\n\n Good luck.";
        label = new Label((CharSequence)toShow, this.labelStyle);
        label.setWrap(true);
        this.table.add((Actor)label).minWidth(790.0f).center();
        this.table.row().padBottom(30.0f);
        TextButton toAdd = new TextButton("Home Screen", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(0);
            }
        });
        this.table.add((Actor)toAdd);
    }

    public void openHelpScreen() {
        Label label = new Label((CharSequence)"Help", this.titleLabelStyle);
        this.table.add((Actor)label);
        this.table.row().padBottom(50.0f);
        String toShow = "To move the human, or main player, use the WSAD keys, and attack using the spacebar. Once you tame some dinosauars simply click the left mouse button to move, or right click an opponent to attack. After a bit, tamed dinosaurs may do there own thing if you have not reinforced orders, and you will need to reissue. Opponents have blue health bars, and those that you have already tamed have green.";
        label = new Label((CharSequence)toShow, this.labelStyle);
        label.setWrap(true);
        this.table.add((Actor)label).minWidth(790.0f).center();
        this.table.row().padBottom(30.0f);
        TextButton toAdd = new TextButton("Home Screen", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(0);
            }
        });
        this.table.add((Actor)toAdd);
    }

    public void returnToPreviousScreen() {
        if (this.getCurrentScreen() != 1 && this.getCurrentScreen() != -1 && this.screenOrder.size >= 2) {
            this.screenOrder.pop();
            this.openScreen((Integer)this.screenOrder.pop());
        }
    }

    public void swapSound() {
        if (this.getSoundIsOn().booleanValue()) {
            this.stopSound();
        } else {
            this.startSound();
        }
    }

    public void startSound() {
        if (this.getCurrentScreen() != 1) {
            this.menuMusic.play();
        } else {
            this.gameMusic.play();
        }
        this.setSoundIsOn(true);
    }

    public void stopSound() {
        this.setSoundIsOn(false);
        this.menuMusic.stop();
        this.gameMusic.stop();
    }

    public void openAboutScreen() {
        Label label = new Label((CharSequence)"About", this.titleLabelStyle);
        this.table.add((Actor)label);
        this.table.row().padBottom(50.0f);
        String toShow = "Created by Michael Adsit as part of a GameDev.net contest.";
        label = new Label((CharSequence)toShow, this.labelStyle);
        label.setWrap(true);
        this.table.add((Actor)label).minWidth(790.0f).center();
        this.table.row().padBottom(30.0f);
        TextButton toAdd = new TextButton("Home Screen", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(0);
            }
        });
        this.table.add((Actor)toAdd);
    }

    public void startGameClicked() {
        this.openScreen(1);
        this.game.newGame();
        if (this.getSoundIsOn().booleanValue()) {
            this.roar.play();
        }
    }

    public void openScreen(int screenID) {
        this.table.clear();
        if (screenID == 1) {
            this.tableHolder.setVisible(false);
            this.gameGroup.setVisible(true);
        } else {
            this.gameGroup.setVisible(false);
            this.tableHolder.setVisible(true);
        }
        this.screenOrder.add((Object)screenID);
        if (this.getSoundIsOn().booleanValue()) {
            if (screenID == 0 && !this.menuMusic.isPlaying()) {
                this.gameMusic.stop();
                this.menuMusic.play();
            } else if (screenID == 1 && !this.gameMusic.isPlaying()) {
                this.menuMusic.stop();
                this.gameMusic.play();
            }
        }
        if (screenID != 1 && this.game.getStatus() == 0) {
            this.game.setStatus(2);
        } else if (screenID == 1 && this.game.getStatus() == 2) {
            this.game.setStatus(0);
        }
        if (screenID == 1) {
            this.gameActor.setVisible(true);
        } else if (screenID == 0) {
            this.openHomeScreen();
        } else if (screenID == 3) {
            this.openAboutScreen();
        } else if (screenID == 5) {
            this.openHelpScreen();
        } else if (screenID == 4) {
            this.openStoryScreen();
        } else if (screenID == 2) {
            this.openMenuScreen();
        } else if (screenID == 6) {
            this.openGameOverScreen();
        }
    }

    private void setSoundIsOn(boolean soundIsOn) {
        if (this.preferences != null) {
            this.preferences.putBoolean("soundIsOn", soundIsOn);
            this.preferences.flush();
        }
        this.soundIsOn = soundIsOn;
    }

    private Boolean getSoundIsOn() {
        if (this.soundIsOn == null) {
            if (this.preferences != null) {
                this.setSoundIsOn(this.preferences.getBoolean("soundIsOn", true));
            } else {
                this.setSoundIsOn(true);
            }
        }
        return this.soundIsOn;
    }

    private void setMusicPath(String musicPath) {
        String path = "sound/music/musicB.ogg";
        FileHandle toLoad = Gdx.files.internal(musicPath);
        if (toLoad.exists()) {
            path = musicPath;
        }
        if (this.preferences != null) {
            this.preferences.putString("music", path);
            this.preferences.flush();
        }
        this.musicPath = path;
    }

    private String getMusicPath() {
        if (this.musicPath == null) {
            if (this.preferences != null) {
                this.setMusicPath(this.preferences.getString("music", "sound/music/musicB.ogg"));
            } else {
                this.setMusicPath("sound/music/musicB.ogg");
            }
        }
        return this.musicPath;
    }

    public void initializeGraphics() {
        this.stage = new Stage();
        this.initializeGameTextures();
        this.initializeMenuTextures();
        this.initializeFonts();
        this.initializeMenuStyles();
        this.initializeTable();
        this.createGameSprites();
    }

    public void initializeTable() {
        this.table = new Table();
        this.table.center();
        this.tableHolder = new Table();
        this.tableScrollPane = new ScrollPane((Actor)this.table, this.scrollPaneStyle);
        this.tableScrollPane.setFadeScrollBars(false);
        this.tableHolder = new Table();
        this.tableHolder.setFillParent(true);
        this.tableHolder.add((Actor)this.tableScrollPane).fill().expand();
        this.tableHolder.setVisible(false);
        this.stage.addActor((Actor)this.tableHolder);
    }

    public void initializeFonts() {
        this.font = new BitmapFont(Gdx.files.internal("font/arial32.fnt"), false);
        this.fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.font.setColor(this.fontColor);
        this.largeFont = new BitmapFont(Gdx.files.internal("font/arial32.fnt"), false);
        this.largeFont.setScale(1.5f);
        this.largeFont.setColor(this.fontColor);
        this.extraLargeFont = new BitmapFont(Gdx.files.internal("font/arial32.fnt"), false);
        this.extraLargeFont.setScale(1.5f);
        this.extraLargeFont.setColor(this.fontColor);
    }

    public void initializeMenuStyles() {
        this.labelStyle = new Label.LabelStyle();
        this.labelStyle.font = this.font;
        this.labelStyle.fontColor = Color.WHITE;
        this.subTitleLabelStyle = new Label.LabelStyle();
        this.subTitleLabelStyle.font = this.largeFont;
        this.subTitleLabelStyle.fontColor = Color.valueOf((String)"01f616");
        this.titleLabelStyle = new Label.LabelStyle();
        this.titleLabelStyle.font = this.extraLargeFont;
        this.titleLabelStyle.fontColor = Color.valueOf((String)"f60102");
        this.textFieldStyle = new TextField.TextFieldStyle();
        this.textFieldStyle.background = new NinePatchDrawable(new NinePatch(this.textBoxBackgroundRegion, 8, 8, 8, 8));
        this.textFieldStyle.cursor = new TextureRegionDrawable(this.textBoxCursorRegion);
        this.textFieldStyle.font = this.font;
        this.textFieldStyle.fontColor = Color.valueOf((String)"01bff6");
        this.textFieldStyle.selection = new TextureRegionDrawable(this.textBoxSelectRegion);
        this.textButtonStyle = new TextButton.TextButtonStyle();
        this.textButtonStyle.up = new NinePatchDrawable(new NinePatch(this.buttonUpBackgroundRegion, 10, 10, 10, 10));
        this.textButtonStyle.down = new NinePatchDrawable(new NinePatch(this.buttonDownBackgroundRegion, 10, 10, 10, 10));
        this.textButtonStyle.font = this.font;
        this.textButtonStyle.fontColor = Color.valueOf((String)"f601d3");
        this.checkableTextButtonStyle = new TextButton.TextButtonStyle();
        this.checkableTextButtonStyle.up = new NinePatchDrawable(new NinePatch(this.buttonUpBackgroundRegion, 10, 10, 10, 10));
        this.checkableTextButtonStyle.down = new NinePatchDrawable(new NinePatch(this.buttonDownBackgroundRegion, 10, 10, 10, 10));
        this.checkableTextButtonStyle.font = this.font;
        this.checkableTextButtonStyle.fontColor = Color.valueOf((String)"f601d3");
        this.checkableTextButtonStyle.checkedFontColor = Color.valueOf((String)"f60110");
        this.scrollPaneStyle = new ScrollPane.ScrollPaneStyle();
        this.sliderStyle = new Slider.SliderStyle();
        this.sliderStyle.background = new NinePatchDrawable(new NinePatch(this.sliderBackgroundRegion));
        this.sliderStyle.knob = new TextureRegionDrawable(this.ballRegion);
    }

    public void initializeMenuTextures() {
        this.textBoxBackgroundRegion = this.textureAtlas.findRegion("TextBoxBase");
        this.textBoxCursorRegion = this.textureAtlas.findRegion("TextBoxCursor");
        this.textBoxSelectRegion = this.textureAtlas.findRegion("TextBoxSelect");
        this.buttonDownBackgroundRegion = this.textureAtlas.findRegion("ButtonDownBackground");
        this.buttonUpBackgroundRegion = this.textureAtlas.findRegion("ButtonUpBackground");
        this.backgroundRegion = this.textureAtlas.findRegion("backgroundBlack");
        this.sliderBackgroundRegion = this.textureAtlas.findRegion("SliderBackground");
        this.ballRegion = this.textureAtlas.findRegion("ball");
    }

    public void initializeStyles() {
        this.labelStyle = new Label.LabelStyle();
        this.labelStyle.font = this.font;
        this.labelStyle.fontColor = Color.WHITE;
        this.subTitleLabelStyle = new Label.LabelStyle();
        this.subTitleLabelStyle.font = this.largeFont;
        this.subTitleLabelStyle.fontColor = Color.valueOf((String)"01f616");
        this.titleLabelStyle = new Label.LabelStyle();
        this.titleLabelStyle.font = this.extraLargeFont;
        this.titleLabelStyle.fontColor = Color.valueOf((String)"f60102");
        this.textFieldStyle = new TextField.TextFieldStyle();
        this.textFieldStyle.background = new NinePatchDrawable(new NinePatch(this.textBoxBackgroundRegion, 8, 8, 8, 8));
        this.textFieldStyle.cursor = new TextureRegionDrawable(this.textBoxCursorRegion);
        this.textFieldStyle.font = this.font;
        this.textFieldStyle.fontColor = Color.valueOf((String)"01bff6");
        this.textFieldStyle.selection = new TextureRegionDrawable(this.textBoxSelectRegion);
        this.textButtonStyle = new TextButton.TextButtonStyle();
        this.textButtonStyle.up = new NinePatchDrawable(new NinePatch(this.buttonUpBackgroundRegion, 10, 10, 10, 10));
        this.textButtonStyle.down = new NinePatchDrawable(new NinePatch(this.buttonDownBackgroundRegion, 10, 10, 10, 10));
        this.textButtonStyle.font = this.font;
        this.textButtonStyle.fontColor = Color.valueOf((String)"f601d3");
        this.checkableTextButtonStyle = new TextButton.TextButtonStyle();
        this.checkableTextButtonStyle.up = new NinePatchDrawable(new NinePatch(this.buttonUpBackgroundRegion, 10, 10, 10, 10));
        this.checkableTextButtonStyle.down = new NinePatchDrawable(new NinePatch(this.buttonDownBackgroundRegion, 10, 10, 10, 10));
        this.checkableTextButtonStyle.font = this.font;
        this.checkableTextButtonStyle.fontColor = Color.valueOf((String)"f601d3");
        this.checkableTextButtonStyle.checkedFontColor = Color.valueOf((String)"f60110");
        this.scrollPaneStyle = new ScrollPane.ScrollPaneStyle();
    }

    public void createGameSprites() {
        SpriteComponent playerSprite = new SpriteComponent(false);
        playerSprite.addStateTexture(1, this.person_away);
        playerSprite.addStateTexture(1, this.person_away_2);
        playerSprite.addStateTexture(0, this.person_away);
        playerSprite.addStateTexture(0, this.person_away_2);
        playerSprite.addStateTexture(4, this.person_away);
        playerSprite.addStateTexture(4, this.person_away_2);
        playerSprite.addStateTexture(6, this.person_away);
        playerSprite.addStateTexture(6, this.person_away_2);
        playerSprite.addStateTexture(3, this.person_toward);
        playerSprite.addStateTexture(3, this.person_toward_2);
        playerSprite.addStateTexture(2, this.person_toward);
        playerSprite.addStateTexture(2, this.person_toward_2);
        playerSprite.addStateTexture(7, this.person_toward);
        playerSprite.addStateTexture(7, this.person_toward_2);
        playerSprite.addStateTexture(5, this.person_toward);
        playerSprite.addStateTexture(5, this.person_toward_2);
        playerSprite.addStateTexture(9, this.person_away_with_weapon);
        playerSprite.addStateTexture(9, this.person_away_with_weapon_2);
        playerSprite.addStateTexture(8, this.person_away_with_weapon);
        playerSprite.addStateTexture(8, this.person_away_with_weapon_2);
        playerSprite.addStateTexture(12, this.person_away_with_weapon);
        playerSprite.addStateTexture(12, this.person_away_with_weapon_2);
        playerSprite.addStateTexture(14, this.person_away_with_weapon_left);
        playerSprite.addStateTexture(14, this.person_away_with_weapon_left_2);
        playerSprite.addStateTexture(14, this.person_away_with_weapon_left);
        playerSprite.addStateTexture(14, this.person_away_with_weapon_left_2);
        playerSprite.addStateTexture(11, this.person_toward_with_left_weapon);
        playerSprite.addStateTexture(11, this.person_toward_with_left_weapon_2);
        playerSprite.addStateTexture(10, this.person_toward_with_left_weapon);
        playerSprite.addStateTexture(10, this.person_toward_with_left_weapon_2);
        playerSprite.addStateTexture(15, this.person_toward_with_left_weapon);
        playerSprite.addStateTexture(15, this.person_toward_with_left_weapon_2);
        playerSprite.addStateTexture(13, this.person_toward_with_weapon);
        playerSprite.addStateTexture(13, this.person_toward_with_weapon_2);
        playerSprite.addTextureRectangle(this.person_away, 50.0f);
        playerSprite.addTextureRectangle(this.person_away_2, 50.0f);
        playerSprite.addTextureRectangle(this.person_away_with_weapon, 50.0f);
        playerSprite.addTextureRectangle(this.person_away_with_weapon_2, 50.0f);
        playerSprite.addTextureRectangle(this.person_away_with_weapon_left, 50.0f);
        playerSprite.addTextureRectangle(this.person_away_with_weapon_left_2, 50.0f);
        playerSprite.addTextureRectangle(this.person_toward, 50.0f);
        playerSprite.addTextureRectangle(this.person_toward_2, 50.0f);
        playerSprite.addTextureRectangle(this.person_toward_with_left_weapon, 50.0f);
        playerSprite.addTextureRectangle(this.person_toward_with_left_weapon_2, 50.0f);
        playerSprite.addTextureRectangle(this.person_toward_with_weapon, 50.0f);
        playerSprite.addTextureRectangle(this.person_toward_with_weapon_2, 50.0f);
        playerSprite.addDefenseRectangle(this.person_away, new Rectangle(-19.0f, -23.0f, 38.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_away_2, new Rectangle(-19.0f, -23.0f, 38.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_toward, new Rectangle(-19.0f, -23.0f, 38.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_toward_2, new Rectangle(-19.0f, -23.0f, 38.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_away_with_weapon, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_away_with_weapon_2, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_away_with_weapon_left, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_away_with_weapon_left_2, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_toward_with_left_weapon, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_toward_with_left_weapon_2, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_toward_with_weapon, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addDefenseRectangle(this.person_toward_with_weapon_2, new Rectangle(-20.0f, -23.0f, 40.0f, 46.0f));
        playerSprite.addAttackRectangle(this.person_away_with_weapon, new Rectangle(7.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_away_with_weapon_2, new Rectangle(7.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_toward_with_weapon, new Rectangle(7.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_toward_with_weapon_2, new Rectangle(7.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_away_with_weapon_left, new Rectangle(-27.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_away_with_weapon_left_2, new Rectangle(-27.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_toward_with_left_weapon, new Rectangle(-27.0f, 3.0f, 20.0f, 21.0f));
        playerSprite.addAttackRectangle(this.person_toward_with_left_weapon_2, new Rectangle(-27.0f, 3.0f, 20.0f, 21.0f));
        SpriteComponent longNeckSprite = new SpriteComponent(true);
        longNeckSprite.addStateTexture(1, this.long_neck_1);
        longNeckSprite.addStateTexture(1, this.long_neck_2);
        longNeckSprite.addStateTexture(0, this.long_neck_1);
        longNeckSprite.addStateTexture(0, this.long_neck_2);
        longNeckSprite.addStateTexture(4, this.long_neck_1);
        longNeckSprite.addStateTexture(4, this.long_neck_2);
        longNeckSprite.addStateTexture(6, this.long_neck_left_1);
        longNeckSprite.addStateTexture(6, this.long_neck_left_2);
        longNeckSprite.addStateTexture(3, this.long_neck_left_1);
        longNeckSprite.addStateTexture(3, this.long_neck_left_2);
        longNeckSprite.addStateTexture(2, this.long_neck_left_1);
        longNeckSprite.addStateTexture(2, this.long_neck_left_2);
        longNeckSprite.addStateTexture(7, this.long_neck_left_1);
        longNeckSprite.addStateTexture(7, this.long_neck_left_2);
        longNeckSprite.addStateTexture(5, this.long_neck_1);
        longNeckSprite.addStateTexture(5, this.long_neck_2);
        longNeckSprite.addStateTexture(9, this.long_neck_attacking_1);
        longNeckSprite.addStateTexture(8, this.long_neck_attacking_1);
        longNeckSprite.addStateTexture(12, this.long_neck_attacking_1);
        longNeckSprite.addStateTexture(14, this.long_neck_attacking_left_1);
        longNeckSprite.addStateTexture(11, this.long_neck_attacking_left_1);
        longNeckSprite.addStateTexture(10, this.long_neck_attacking_left_1);
        longNeckSprite.addStateTexture(15, this.long_neck_attacking_left_1);
        longNeckSprite.addStateTexture(13, this.long_neck_attacking_1);
        longNeckSprite.addTextureRectangle(this.long_neck_1, 150.0f);
        longNeckSprite.addTextureRectangle(this.long_neck_2, 150.0f);
        longNeckSprite.addTextureRectangle(this.long_neck_attacking_1, 150.0f);
        longNeckSprite.addTextureRectangle(this.long_neck_left_1, 150.0f);
        longNeckSprite.addTextureRectangle(this.long_neck_left_2, 150.0f);
        longNeckSprite.addTextureRectangle(this.long_neck_attacking_left_1, 150.0f);
        longNeckSprite.addDefenseRectangle(this.long_neck_1, new Rectangle(-70.0f, -75.0f, 150.0f, 150.0f));
        longNeckSprite.addDefenseRectangle(this.long_neck_2, new Rectangle(-70.0f, -75.0f, 150.0f, 150.0f));
        longNeckSprite.addDefenseRectangle(this.long_neck_attacking_1, new Rectangle(-100.0f, -70.0f, 200.0f, 130.0f));
        longNeckSprite.addAttackRectangle(this.long_neck_attacking_1, new Rectangle(145.0f, -20.0f, 45.0f, 70.0f));
        longNeckSprite.addDefenseRectangle(this.long_neck_left_1, new Rectangle(-70.0f, -75.0f, 150.0f, 150.0f));
        longNeckSprite.addDefenseRectangle(this.long_neck_left_2, new Rectangle(-70.0f, -75.0f, 150.0f, 150.0f));
        longNeckSprite.addDefenseRectangle(this.long_neck_attacking_left_1, new Rectangle(-100.0f, -70.0f, 200.0f, 130.0f));
        longNeckSprite.addAttackRectangle(this.long_neck_attacking_left_1, new Rectangle(-195.0f, -20.0f, 45.0f, 70.0f));
        SpriteComponent salamanderSprite = new SpriteComponent(true);
        salamanderSprite.addStateTexture(1, this.salamander_1);
        salamanderSprite.addStateTexture(1, this.salamander_2);
        salamanderSprite.addStateTexture(0, this.salamander_1);
        salamanderSprite.addStateTexture(0, this.salamander_2);
        salamanderSprite.addStateTexture(4, this.salamander_1);
        salamanderSprite.addStateTexture(4, this.salamander_2);
        salamanderSprite.addStateTexture(6, this.salamander_left_1);
        salamanderSprite.addStateTexture(6, this.salamander_left_2);
        salamanderSprite.addStateTexture(3, this.salamander_left_1);
        salamanderSprite.addStateTexture(3, this.salamander_left_2);
        salamanderSprite.addStateTexture(2, this.salamander_left_1);
        salamanderSprite.addStateTexture(2, this.salamander_left_2);
        salamanderSprite.addStateTexture(7, this.salamander_left_1);
        salamanderSprite.addStateTexture(7, this.salamander_left_2);
        salamanderSprite.addStateTexture(5, this.salamander_1);
        salamanderSprite.addStateTexture(5, this.salamander_2);
        salamanderSprite.addStateTexture(9, this.salamander_1);
        salamanderSprite.addStateTexture(9, this.salamander_left_1);
        salamanderSprite.addStateTexture(8, this.salamander_1);
        salamanderSprite.addStateTexture(8, this.salamander_left_1);
        salamanderSprite.addStateTexture(12, this.salamander_1);
        salamanderSprite.addStateTexture(12, this.salamander_left_1);
        salamanderSprite.addStateTexture(14, this.salamander_left_1);
        salamanderSprite.addStateTexture(14, this.salamander_left_1);
        salamanderSprite.addStateTexture(14, this.salamander_left_1);
        salamanderSprite.addStateTexture(14, this.salamander_left_1);
        salamanderSprite.addStateTexture(11, this.salamander_1);
        salamanderSprite.addStateTexture(11, this.salamander_left_1);
        salamanderSprite.addStateTexture(10, this.salamander_1);
        salamanderSprite.addStateTexture(10, this.salamander_left_1);
        salamanderSprite.addStateTexture(15, this.salamander_1);
        salamanderSprite.addStateTexture(15, this.salamander_left_1);
        salamanderSprite.addStateTexture(13, this.salamander_1);
        salamanderSprite.addStateTexture(13, this.salamander_left_1);
        salamanderSprite.addTextureRectangle(this.salamander_1, 70.0f);
        salamanderSprite.addTextureRectangle(this.salamander_2, 70.0f);
        salamanderSprite.addTextureRectangle(this.salamander_left_1, 70.0f);
        salamanderSprite.addTextureRectangle(this.salamander_left_2, 70.0f);
        salamanderSprite.addDefenseRectangle(this.salamander_1, new Rectangle(-35.0f, -35.0f, 70.0f, 70.0f));
        salamanderSprite.addDefenseRectangle(this.salamander_2, new Rectangle(-35.0f, -35.0f, 70.0f, 70.0f));
        salamanderSprite.addDefenseRectangle(this.salamander_left_1, new Rectangle(-35.0f, -35.0f, 70.0f, 70.0f));
        salamanderSprite.addDefenseRectangle(this.salamander_left_2, new Rectangle(-35.0f, -35.0f, 70.0f, 70.0f));
        SpriteComponent triceritopsSprite = new SpriteComponent(true);
        triceritopsSprite.addStateTexture(1, this.triceritops_1);
        triceritopsSprite.addStateTexture(1, this.triceritops_2);
        triceritopsSprite.addStateTexture(0, this.triceritops_1);
        triceritopsSprite.addStateTexture(0, this.triceritops_2);
        triceritopsSprite.addStateTexture(4, this.triceritops_1);
        triceritopsSprite.addStateTexture(4, this.triceritops_2);
        triceritopsSprite.addStateTexture(6, this.triceritops_left_1);
        triceritopsSprite.addStateTexture(6, this.triceritops_left_2);
        triceritopsSprite.addStateTexture(3, this.triceritops_left_1);
        triceritopsSprite.addStateTexture(3, this.triceritops_left_2);
        triceritopsSprite.addStateTexture(2, this.triceritops_left_1);
        triceritopsSprite.addStateTexture(2, this.triceritops_left_2);
        triceritopsSprite.addStateTexture(7, this.triceritops_left_1);
        triceritopsSprite.addStateTexture(7, this.triceritops_left_2);
        triceritopsSprite.addStateTexture(5, this.triceritops_1);
        triceritopsSprite.addStateTexture(5, this.triceritops_2);
        triceritopsSprite.addStateTexture(9, this.triceritops_attacking);
        triceritopsSprite.addStateTexture(8, this.triceritops_attacking);
        triceritopsSprite.addStateTexture(12, this.triceritops_attacking);
        triceritopsSprite.addStateTexture(14, this.triceritops_attacking_left);
        triceritopsSprite.addStateTexture(11, this.triceritops_attacking_left);
        triceritopsSprite.addStateTexture(10, this.triceritops_attacking_left);
        triceritopsSprite.addStateTexture(15, this.triceritops_attacking_left);
        triceritopsSprite.addStateTexture(13, this.triceritops_attacking);
        triceritopsSprite.addTextureRectangle(this.triceritops_1, 100.0f);
        triceritopsSprite.addTextureRectangle(this.triceritops_2, 100.0f);
        triceritopsSprite.addTextureRectangle(this.triceritops_left_1, 100.0f);
        triceritopsSprite.addTextureRectangle(this.triceritops_left_2, 100.0f);
        triceritopsSprite.addTextureRectangle(this.triceritops_attacking, 100.0f);
        triceritopsSprite.addTextureRectangle(this.triceritops_attacking_left, 100.0f);
        triceritopsSprite.addDefenseRectangle(this.triceritops_1, new Rectangle(-100.0f, -35.0f, 200.0f, 70.0f));
        triceritopsSprite.addDefenseRectangle(this.triceritops_2, new Rectangle(-100.0f, -35.0f, 200.0f, 70.0f));
        triceritopsSprite.addDefenseRectangle(this.triceritops_attacking, new Rectangle(-100.0f, -35.0f, 200.0f, 70.0f));
        triceritopsSprite.addDefenseRectangle(this.triceritops_left_1, new Rectangle(-100.0f, -35.0f, 200.0f, 70.0f));
        triceritopsSprite.addDefenseRectangle(this.triceritops_left_2, new Rectangle(-100.0f, -35.0f, 200.0f, 70.0f));
        triceritopsSprite.addDefenseRectangle(this.triceritops_attacking_left, new Rectangle(-100.0f, -35.0f, 200.0f, 70.0f));
        triceritopsSprite.addAttackRectangle(this.triceritops_attacking, new Rectangle(70.0f, -35.0f, 50.0f, 70.0f));
        triceritopsSprite.addAttackRectangle(this.triceritops_attacking_left, new Rectangle(-110.0f, -35.0f, 50.0f, 70.0f));
        this.entityFactory = new EntityFactory(playerSprite, longNeckSprite, salamanderSprite, triceritopsSprite);
    }

    public void initializeGameTextures() {
        this.textureAtlas = new TextureAtlas(Gdx.files.internal("packs/dinoTamer.pack"));
        this.person_away = this.textureAtlas.findRegion("person_away");
        this.person_away_2 = this.textureAtlas.findRegion("person_away", 2);
        this.person_away_with_weapon = this.textureAtlas.findRegion("person_away_with_weapon");
        this.person_away_with_weapon_2 = this.textureAtlas.findRegion("person_away_with_weapon", 2);
        this.person_away_with_weapon_left_2 = this.textureAtlas.findRegion("person_away_with_weapon_left", 2);
        this.person_toward = this.textureAtlas.findRegion("person_toward");
        this.person_toward_2 = this.textureAtlas.findRegion("person_toward", 2);
        this.person_toward_with_left_weapon_2 = this.textureAtlas.findRegion("person_toward_with_left_weapon", 2);
        this.person_toward_with_weapon = this.textureAtlas.findRegion("person_toward_with_weapon");
        this.person_toward_with_weapon_2 = this.textureAtlas.findRegion("person_toward_with_weapon", 2);
        this.person_away = this.textureAtlas.findRegion("person_away");
        this.person_away_2 = this.textureAtlas.findRegion("person_away", 2);
        this.person_away_with_weapon = this.textureAtlas.findRegion("person_away_with_weapon");
        this.person_away_with_weapon_2 = this.textureAtlas.findRegion("person_away_with_weapon", 2);
        this.person_away_with_weapon_left = this.textureAtlas.findRegion("person_away_with_weapon_left");
        this.person_away_with_weapon_left_2 = this.textureAtlas.findRegion("person_away_with_weapon_left", 2);
        this.person_toward = this.textureAtlas.findRegion("person_toward");
        this.person_toward_2 = this.textureAtlas.findRegion("person_toward", 2);
        this.person_toward_with_left_weapon = this.textureAtlas.findRegion("person_toward_with_left_weapon");
        this.person_toward_with_left_weapon_2 = this.textureAtlas.findRegion("person_toward_with_left_weapon", 2);
        this.person_toward_with_weapon = this.textureAtlas.findRegion("person_toward_with_weapon");
        this.person_toward_with_weapon_2 = this.textureAtlas.findRegion("person_toward_with_weapon", 2);
        this.long_neck_1 = this.textureAtlas.findRegion("long_neck", 1);
        this.long_neck_left_1 = this.textureAtlas.findRegion("long_neck_left", 1);
        this.long_neck_2 = this.textureAtlas.findRegion("long_neck", 2);
        this.long_neck_left_2 = this.textureAtlas.findRegion("long_neck_left", 2);
        this.long_neck_attacking_1 = this.textureAtlas.findRegion("long_neck_attacking", 1);
        this.long_neck_attacking_left_1 = this.textureAtlas.findRegion("long_neck_attacking_left", 1);
        this.salamander_1 = this.textureAtlas.findRegion("salamander", 1);
        this.salamander_2 = this.textureAtlas.findRegion("salamander", 2);
        this.salamander_left_1 = this.textureAtlas.findRegion("salamander_left", 1);
        this.salamander_left_2 = this.textureAtlas.findRegion("salamander_left", 2);
        this.triceritops_left_1 = this.textureAtlas.findRegion("triceritops_left", 1);
        this.triceritops_left_2 = this.textureAtlas.findRegion("triceritops_left", 2);
        this.triceritops_attacking_left = this.textureAtlas.findRegion("triceritops_attacking_left", 1);
        this.triceritops_1 = this.textureAtlas.findRegion("triceritops", 1);
        this.triceritops_2 = this.textureAtlas.findRegion("triceritops", 2);
        this.triceritops_attacking = this.textureAtlas.findRegion("triceritops_attacking", 1);
    }

    public void openGameOverScreen() {
        Label label = new Label((CharSequence)"Game Over", this.titleLabelStyle);
        this.table.add((Actor)label);
        this.table.row().padBottom(50.0f);
        String toShow = "Congratulations on taming " + this.game.getScore() + " dinosaurs in " + MathUtils.round((float)this.game.getTimeSoFar()) + " seconds.";
        label = new Label((CharSequence)toShow, this.labelStyle);
        label.setWrap(true);
        this.table.add((Actor)label).minWidth(790.0f).center();
        this.table.row().padBottom(30.0f);
        TextButton toAdd = new TextButton("Home Screen", this.textButtonStyle);
        toAdd.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                MyGdxGame.this.openScreen(0);
            }
        });
        this.table.add((Actor)toAdd);
    }

    public void notifyKeyDownComponents(int keycode) {
        this.game.getEntityController().updateKeyDown(keycode);
    }

    public void handleClick(float x, float y, int button) {
        if (button == 0) {
            this.game.moveToLocation(x, y);
        } else if (button == 1) {
            this.game.attackEntityAt(x, y);
        }
    }

    public void dispose() {
        this.textureAtlas.dispose();
        this.shapeRenderer.dispose();
        this.stage.dispose();
        this.batch.dispose();
        this.largeFont.dispose();
        this.font.dispose();
        this.menuMusic.dispose();
        this.gameMusic.dispose();
        this.fire.dispose();
        this.roar.dispose();
        this.hit.dispose();
        this.backgroundTexture.dispose();
    }

    public void render() {
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.game.advance(Gdx.graphics.getDeltaTime());
        if (this.gameGroup.isVisible()) {
            this.gameScore.setText((CharSequence)("Score: " + this.game.getScore()));
            this.gameTime.setText((CharSequence)("Time: " + Math.round(this.game.getTimeSoFar()) * 100 / 100));
            if (this.game.getStatus() == 1) {
                this.game.setStatus(5);
                this.openScreen(6);
            } else if (this.getSoundIsOn().booleanValue()) {
                for (Entity entity : this.game.getEntityController().getAttackingEntities().values()) {
                    SoundEffectComponent soundEffectComponent = (SoundEffectComponent)entity.getComponent("SoundEffectComponent");
                    CurrentlyAttackingComponent currentAttack = (CurrentlyAttackingComponent)entity.getComponent("CurrentlyAttackingComponent");
                    if (soundEffectComponent == null || currentAttack == null || !(currentAttack.getCurrentAttackDuration() <= Gdx.graphics.getDeltaTime())) continue;
                    int soundEffect = soundEffectComponent.getSoundEffect();
                    if (soundEffect == 0) {
                        this.fire.play();
                    }
                    if (soundEffect != 1) continue;
                    this.hit.play();
                }
            }
        }
        this.batch.begin();
        if (this.game.getStatus() == 0) {
            this.batch.draw(this.backgroundTexture, 0.0f, 0.0f, 800.0f, 800.0f);
        } else {
            this.batch.draw(this.backgroundRegion, 0.0f, 0.0f, 800.0f, 800.0f);
        }
        this.batch.end();
        this.stage.act();
        this.stage.draw();
    }

    public void resize(int width, int height) {
        this.stage.setViewport(800.0f, 800.0f, false);
    }

    public void pause() {
        if (this.game.getStatus() == 0) {
            this.game.setStatus(2);
        }
    }

    public void resume() {
        if (this.game.getStatus() == 2) {
            this.game.setStatus(0);
        }
    }
}

