/*
 * Decompiled with CFR 0.152.
 */
package com.adsittech.dinotamer;

import com.adsittech.dinotamer.Component;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.ArrayList;

public class SpriteComponent
extends Component {
    private ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> stateToTextures;
    private ObjectMap<TextureAtlas.AtlasRegion, Rectangle> textureRectangles;
    private ObjectMap<TextureAtlas.AtlasRegion, Rectangle> defenseRectangles;
    private ObjectMap<TextureAtlas.AtlasRegion, Rectangle> attackRectangles;
    private boolean flipForEastWest;
    private int currentState;
    private boolean flipEastWestNow;
    private float timeSinceLastSpriteChange;
    private int lastSpriteSequence;
    public static final int STATE_NORTH = 0;
    public static final int STATE_EAST = 1;
    public static final int STATE_SOUTH = 2;
    public static final int STATE_WEST = 3;
    public static final int STATE_NORTH_EAST = 4;
    public static final int STATE_SOUTH_EAST = 5;
    public static final int STATE_NORTH_WEST = 6;
    public static final int STATE_SOUTH_WEST = 7;
    public static final int STATE_NORTH_ATTACKING = 8;
    public static final int STATE_EAST_ATTACKING = 9;
    public static final int STATE_SOUTH_ATTACKING = 10;
    public static final int STATE_WEST_ATTACKING = 11;
    public static final int STATE_NORTH_EAST_ATTACKING = 12;
    public static final int STATE_SOUTH_EAST_ATTACKING = 13;
    public static final int STATE_NORTH_WEST_ATTACKING = 14;
    public static final int STATE_SOUTH_WEST_ATTACKING = 15;

    public SpriteComponent(boolean flipForEastWest) {
        this(flipForEastWest, (ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>>)new ObjectMap());
    }

    public SpriteComponent(boolean flipForEastWest, ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> stateToTextures) {
        this(flipForEastWest, stateToTextures, (ObjectMap<TextureAtlas.AtlasRegion, Rectangle>)new ObjectMap());
    }

    public SpriteComponent(boolean flipForEastWest, ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> stateToTextures, ObjectMap<TextureAtlas.AtlasRegion, Rectangle> textureRectangles) {
        this(flipForEastWest, stateToTextures, textureRectangles, 1);
    }

    public SpriteComponent(boolean flipForEastWest, ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> stateToTextures, ObjectMap<TextureAtlas.AtlasRegion, Rectangle> textureRectangles, int currentState) {
        this(flipForEastWest, stateToTextures, textureRectangles, currentState, (ObjectMap<TextureAtlas.AtlasRegion, Rectangle>)new ObjectMap(), (ObjectMap<TextureAtlas.AtlasRegion, Rectangle>)new ObjectMap());
    }

    public SpriteComponent(boolean flipForEastWest, ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> stateToTextures, ObjectMap<TextureAtlas.AtlasRegion, Rectangle> textureRectangles, int currentState, ObjectMap<TextureAtlas.AtlasRegion, Rectangle> defenseRectangles, ObjectMap<TextureAtlas.AtlasRegion, Rectangle> attackRectangles) {
        this.setFlipForEastWest(flipForEastWest);
        this.setStateToTextures(stateToTextures);
        this.setTextureRectangles(textureRectangles);
        this.setDefenseRectangles(defenseRectangles);
        this.setAttackRectangles(attackRectangles);
        this.lastSpriteSequence = 0;
        this.timeSinceLastSpriteChange = 0.0f;
        this.flipEastWestNow = false;
    }

    public void addStateTexture(int state, TextureAtlas.AtlasRegion texture) {
        if (this.stateToTextures.get((Object)state) == null) {
            this.stateToTextures.put((Object)state, new ArrayList());
        }
        ((ArrayList)this.stateToTextures.get((Object)state)).add(texture);
    }

    public void removeStateTexture(int state, TextureAtlas.AtlasRegion texture) {
        if (this.stateToTextures.get((Object)state) != null) {
            ((ArrayList)this.stateToTextures.get((Object)state)).remove(texture);
        }
    }

    public void addTextureRectangle(TextureAtlas.AtlasRegion region, float height) {
        if (height < 0.0f) {
            height = 1.0f;
        }
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, height / (float)region.originalHeight * (float)region.originalWidth, height);
        this.textureRectangles.put((Object)region, (Object)rectangle);
    }

    public void addTextureRectangle(TextureAtlas.AtlasRegion region, Rectangle rectangle) {
        this.textureRectangles.put((Object)region, (Object)rectangle);
    }

    public void addDefenseRectangle(TextureAtlas.AtlasRegion region, Rectangle rectangle) {
        this.defenseRectangles.put((Object)region, (Object)rectangle);
    }

    public void addAttackRectangle(TextureAtlas.AtlasRegion region, Rectangle rectangle) {
        this.attackRectangles.put((Object)region, (Object)rectangle);
    }

    public Rectangle getDefenseRectangle(TextureAtlas.AtlasRegion region) {
        if (region == null) {
            return null;
        }
        return (Rectangle)this.defenseRectangles.get((Object)region);
    }

    public Rectangle getAttackRectangle(TextureAtlas.AtlasRegion region) {
        if (region == null) {
            return null;
        }
        return (Rectangle)this.attackRectangles.get((Object)region);
    }

    public Rectangle getTextureRectangle(TextureAtlas.AtlasRegion region) {
        Rectangle toReturn = (Rectangle)this.textureRectangles.get((Object)region);
        if (toReturn == null) {
            toReturn = region == null ? new Rectangle() : new Rectangle(0.0f, 0.0f, (float)region.originalWidth, (float)region.originalHeight);
        }
        return toReturn;
    }

    public void updateTime(float delta) {
        this.timeSinceLastSpriteChange += delta;
    }

    public TextureAtlas.AtlasRegion retrieveCurrentTexture() {
        TextureAtlas.AtlasRegion toReturn = null;
        ArrayList textures = (ArrayList)this.stateToTextures.get((Object)this.currentState);
        if (textures != null) {
            if (this.timeSinceLastSpriteChange > 0.5f) {
                ++this.lastSpriteSequence;
                this.lastSpriteSequence %= textures.size();
                this.timeSinceLastSpriteChange = 0.0f;
            }
            if (textures.size() <= this.lastSpriteSequence) {
                this.lastSpriteSequence = 0;
            }
            toReturn = (TextureAtlas.AtlasRegion)textures.get(this.lastSpriteSequence);
        }
        return toReturn;
    }

    @Override
    public String getComponentName() {
        return "SpriteComponent";
    }

    @Override
    public void add(Component toAdd) {
        this.sameType(toAdd);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "-{" + this.isFlipForEastWest() + ", " + this.getStateToTextures() + "}";
    }

    @Override
    public Component copy() {
        return new SpriteComponent(this.isFlipForEastWest(), this.getStateToTextures(), this.getTextureRectangles(), this.getCurrentState(), this.getDefenseRectangles(), this.getAttackRectangles());
    }

    public ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> getStateToTextures() {
        return this.stateToTextures;
    }

    public void setStateToTextures(ObjectMap<Integer, ArrayList<TextureAtlas.AtlasRegion>> stateToTextures) {
        this.stateToTextures = stateToTextures;
    }

    public boolean isFlipForEastWest() {
        return this.flipForEastWest;
    }

    public void setFlipForEastWest(boolean flipForEastWest) {
        this.flipForEastWest = flipForEastWest;
    }

    public ObjectMap<TextureAtlas.AtlasRegion, Rectangle> getTextureRectangles() {
        return this.textureRectangles;
    }

    public void setTextureRectangles(ObjectMap<TextureAtlas.AtlasRegion, Rectangle> textureRectangles) {
        this.textureRectangles = textureRectangles;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(int currentState) {
        this.currentState = currentState;
    }

    public ObjectMap<TextureAtlas.AtlasRegion, Rectangle> getDefenseRectangles() {
        return this.defenseRectangles;
    }

    public void setDefenseRectangles(ObjectMap<TextureAtlas.AtlasRegion, Rectangle> defenseRectangles) {
        this.defenseRectangles = defenseRectangles;
    }

    public ObjectMap<TextureAtlas.AtlasRegion, Rectangle> getAttackRectangles() {
        return this.attackRectangles;
    }

    public void setAttackRectangles(ObjectMap<TextureAtlas.AtlasRegion, Rectangle> attackRectangles) {
        this.attackRectangles = attackRectangles;
    }

    public boolean isFlipEastWestNow() {
        return this.flipEastWestNow;
    }

    public void setFlipEastWestNow(boolean flipEastWestNow) {
        this.flipEastWestNow = flipEastWestNow;
    }
}

